<?php
/****************************************
 * XKLog 其它函数库
 *
 * 此文件定义其它函数
 *
 * 更新：2009-5-23
 * 版本：V1.0
 ****************************************/

!defined('IN_XKLOG') && exit('Access Denied!');

if (!function_exists('file_put_contents')) {
	function file_put_contents($file, $data, $append = false) {
		$mode = $append ? 'ab' : 'wb';
		$fp = @fopen($file,$mode) or die("can not open file $file !");
		flock($fp, LOCK_EX);
		$len = fwrite($fp, $data);
		flock($fp, LOCK_UN);
		@fclose($fp);
		return $len;
	}
}

//检查用户名是否合法
function check_username($username) {
	global $_CACHE;
	// 检查非法字符
	$badchars = array("\\",'&',' ',"'",'"','/','*',',','<','>',"\r","\t","\n",'#','$','(',')','%','@','+','?',';','^');
	foreach ($badchars as $cha) {
		if (strpos($username,$cha) != false) {
			return false;
		}
	}
	// 检查禁用关键字
	$banname = split( "\|", $_CACHE['set'][0]['NameFilter'] );
	if ( count( $banname ) ) {
		foreach ( $banname as $val ) {
			if ( empty( $val ) ) continue;
			if ( !( strpos( $username, $val ) === false) ) {
				return false;
			}
		}
	}
	return true;
}

//用户登录
//返回值：0 用户名或密码为空，-1 用户不存在，-2 密码错误
function user_login( $username, $password, $remember = 0 ) {
	global $db,$_CACHE;
	if ($username === '' || $password === '') return 0;
	$sql = "SELECT UID,PassWord,`Group` FROM " . PREFIX_STR . "User WHERE UserName = '$username'";
	$result = $db->fetch_one_array($sql);
	if ( !$result ) return -1;
	if ( $result['PassWord'] != strtoupper( md5( PREFIX_STR . $password ) ) ) return -2;
	$expire = $remember ? PHP_TIME + (365 * 24 * 3600) : 0;
	$blog_path = str_replace( ' ','%20', BLOG_PATH );
	setcookie( PREFIX_STR . 'UserName', $username, $expire,$blog_path);
	setcookie( PREFIX_STR . 'PassWord', $result['PassWord'], $expire,$blog_path);
	$_CACHE['user']['user_name'] = $username;
	$_CACHE['user']['user_group'] = $result['Group'];
	$sql = "UPDATE " . PREFIX_STR . "User SET IP = '" . get_ip() . "',Time = '" . PHP_TIME . "' WHERE UserName = '$username'";
	$db->query( $sql );
	return 1;
}

//验证Email是否合法
function check_email($email) {
	if (preg_match('/^[0-9a-z]+[0-9a-z_\.\-]*@[0-9a-z\-]+(\.[a-z]{2,4}){1,2}$/i',$email)) {
		return true;
	}
	return false;
}

//addslashes
function add_slashes($string) {
	if (!is_array($string)) return addslashes($string);
	foreach ($string as $key => $val) {
		$string[$key] = add_slashes($val);
	}
	return $string;
}

function del_slashes($string) {
	if (!is_array($string)) return stripslashes($string);
	foreach ($string as $key => $val) {
		$string[$key] = del_slashes($val);
	}
	return $string;
}

//ob_start
function obstart() {
	global $_CACHE;
	if ( /*get_config('blog','obstart') &&*/ function_exists('ob_gzhandler') ) {
		ob_start('ob_gzhandler');
	} else {
		ob_start();
	}
}
//ob_end_clean
function obclean() {
	ob_end_clean();
	obstart();
}

//获取$_GET或$_POST值
function getGP($var, $method = 'GP', $type = 'string') {
	if ($method == 'G' || $method != 'P' && isset($_GET[$var])) {
		$gp = &$_GET;
	} else {
		$gp = &$_POST;
	}
	if ($type == 'int') {
		return isset($gp[$var]) ? intval($gp[$var]) : 0;
	} elseif ($type == 'array') {
		return isset($gp[$var]) ? (array)$gp[$var] : array();
	} else {
		return isset($gp[$var]) ? (string)trim($gp[$var]) : '';
	}
}

// 载入模板
function template($tpl, $ext = 'php') {
	global $_CACHE;
	$tpl_file = XKLOG_ROOT . 'style/'. $_CACHE['set'][0]['Style'] . '/' . $tpl . '.' . $ext;
	if ( file_exists( $tpl_file ) ) {
		include( $tpl_file );
	} else {
		show_err( "提示信息：模板文件 " . $tpl_file . " 不存在！" );
	}
}

//字符串截取
function cut_str($str, $len = 0, $dot = '...',$encoding = 'utf-8') {
	if (!$len || strlen($str) <= $len) return $str;
	$tempstr = '';
	$str = str_replace(array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $str);
	if ($encoding == 'utf-8') {
		$n = $tn = $noc = 0;
		while($n < strlen($str)) {
			$t = ord($str[$n]);
			if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1; $n++; $noc++;
			} elseif (194 <= $t && $t <= 223) {
				$tn = 2; $n += 2; $noc += 2;
			} elseif (224 <= $t && $t < 239) {
				$tn = 3; $n += 3; $noc += 2;
			} elseif (240 <= $t && $t <= 247) {
				$tn = 4; $n += 4; $noc += 2;
			} elseif (248 <= $t && $t <= 251) {
				$tn = 5; $n += 5; $noc += 2;
			} elseif ($t == 252 || $t == 253) {
				$tn = 6; $n += 6; $noc += 2;
			} else {
				$n++;
			}
			if($noc >= $len) {
				break;
			}
		}
		if($noc > $len) {
			$n -= $tn;
		}
		$tempstr = substr($str, 0, $n);
	} elseif ($encoding == 'gbk') {
		for ($i=0; $i<$len; $i++) {
			$tempstr .= ord($str{$i}) > 127 ? $str{$i}.$str{++$i} : $str{$i};
		}
	}
	$tempstr = str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $tempstr);
	return $tempstr.$dot;
}

function php_escape($str) {
	preg_match_all("/[\x80-\xff].|[\x01-\x7f]+/",$str,$r);
	$ar = $r[0];
	foreach($ar as $k=>$v) {
		if(ord($v[0]) < 128)
			$ar[$k] = rawurlencode($v);
		else
			$ar[$k] = "%u".bin2hex(iconv("UTF-8","UCS-2",$v));
	}
	return join("",$ar);
}

function php_unescape($str) {
	$str = rawurldecode($str);
	preg_match_all("/(?:%u.{4})|.+/",$str,$r);
	$ar = $r[0];
	foreach($ar as $k=>$v) {
		if(substr($v,0,2) == "%u" && strlen($v) == 6) {
			$ar[$k] = iconv("UCS-2","UTF-8",pack("H4",substr($v,-4)));
		}
	}
	return join("",$ar);
}

//
function get_date($format, $timestamp = '') {
	empty($timestamp) && $timestamp = PHP_TIME;
	return gmdate($format, $timestamp + 8 * 3600);
}

// 获得访客 IP
function get_ip(){
	if( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ){
		return $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		return $_SERVER['REMOTE_ADDR'];
	}
}

function get_http_referer() {
	if( isset( $_SERVER['HTTP_REFERER'] ) ){
		return $_SERVER['HTTP_REFERER'];
	}else{
		return '';
	}
}

// 判断是否登录
function user_is_login() {
	global $_CACHE;
	if( $_CACHE['user']['user_group'] > 0 ){
		return true;
	}else{
		return false;
	}
}

// 判断是否有前台管理权限
function user_is_admin() {
	global $_CACHE;
	if( $_CACHE['user']['user_group'] > 7 ){
		return true;
	}else{
		return false;
	}
}

// 判断是否有后台管理权限
function user_is_super_admin() {
	global $_CACHE;
	if( !isset( $_SESSION['user_group'] ) ){
		return false;
	}else{
		if( $_CACHE['user']['user_group'] < 8 && $_CACHE['set'][0]['Enable'] != 0 ) return false;
		if ( $_SESSION['user_group'] < 10 ) return false;
	}
	return true;
}

?>